//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property icon "/Images/Market Replay/Icons/Replay - EA.ico"
#property description "Demo version between interaction"
#property description "of Chart Trade and Expert Advisor"
#property version   "1.84"
#property link "https://www.mql5.com/"
//+------------------------------------------------------------------+
#include <Market Replay\Order System\C_Orders.mqh>
//+------------------------------------------------------------------+
enum eTypeContract {MINI, FULL};
//+------------------------------------------------------------------+
input eTypeContract user00 = MINI; 		//Cross order in contract
//+------------------------------------------------------------------+
C_Orders	*Orders;
long		GL_ID;
//+------------------------------------------------------------------+
int OnInit()
{
	GL_ID = 0;
	Orders = new C_Orders(0xC0DEDAFE78514269);
	
	return INIT_SUCCEEDED;
}
//+------------------------------------------------------------------+
void OnTick() {}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
{
	(*Orders).DispatchMessage(id, lparam, dparam, sparam);
	switch (id)
	{
		case CHARTEVENT_CHART_CHANGE:
			if (GL_ID > 0)	break; else GL_ID = ChartID();
		case CHARTEVENT_CUSTOM + evChartTrade_At_EA:
			EventChartCustom(GL_ID, evEA_At_ChartTrade, user00, 0, "");
			break;
	}
}
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
	switch (reason)
	{
		case REASON_REMOVE:
		case REASON_INITFAILED:
			EventChartCustom(GL_ID, evEA_At_ChartTrade, -1, 0, "");
			break;
	}
	
	delete Orders;
}
//+------------------------------------------------------------------+
